import * as s from '@minecraft/server';

const player = s.world.getAllPlayers()[0];

// Assume the player has granite at slot 0.
const selectedItem = player.getComponent('inventory').container.getItem(player.selectedSlot); // This would return an ItemStack of granite.
if (!selectedItem) throw "Not holding an item, please hold granite and run '/reload'.";

// However, there is no way to know if it is granite because there is no data property on the item.

console.warn('selectedItem.typeId:', selectedItem.typeId /* returns 'minecraft:stone'. */);

for (const property in selectedItem.type /* returns ItemType with only one property, 'id', which equals 'minecraft:stone'. */) console.warn('Property in selectedItem.type:', property, 'Property value:', selectedItem.type[property]);

console.warn('selectedItem.data:', selectedItem.data /* returns undefined. */);

// So, there's no way to know if the item recieved is stone or another stone variant. This also applies to many other blocks and items.